<?php
define('API_ACCESS', true);
require_once 'config.php';

// معالجة إضافة ترخيص جديد
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_license') {
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    $plan = htmlspecialchars($_POST['plan']);
    $expires = !empty($_POST['expires_at']) ? $_POST['expires_at'] : null;
    $new_key = generate_license_key();

    $stmt = $pdo->prepare("INSERT INTO licenses (license_key, email, plan, status, max_sites, expires_at, created_at) VALUES (?, ?, ?, 'active', 1, ?, NOW())");
    $stmt->execute([$new_key, $email, $plan, $expires]);

    header("Location: index.php?success=1");
    exit;
}

// الحصول على إحصائيات سريعة
$total_licenses = $pdo->query("SELECT COUNT(*) FROM licenses")->fetchColumn();
$active_activations = $pdo->query("SELECT COUNT(*) FROM activations")->fetchColumn();
$recent_logs = $pdo->query("SELECT * FROM license_logs ORDER BY created_at DESC LIMIT 5")->fetchAll();

// جلب التراخيص مع بيانات المواقع إذا وجدت
$all_licenses = $pdo->query("
    SELECT l.*, a.site_url as active_url, a.site_name 
    FROM licenses l 
    LEFT JOIN activations a ON l.id = a.license_id 
    ORDER BY l.created_at DESC
")->fetchAll();

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة تحكم التراخيص | Author Box Pro</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #4361ee;
            --success: #2ec4b6;
            --warning: #ff9f1c;
            --danger: #e71d36;
            --dark: #011627;
            --light: #f8f9fa;
        }

        body {
            font-family: 'Tajawal', sans-serif;
            background-color: #f0f2f5;
            margin: 0;
            color: var(--dark);
        }

        .navbar {
            background: var(--dark);
            color: white;
            padding: 1rem 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .container {
            max-width: 1300px;
            margin: 2rem auto;
            padding: 0 1rem;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        .stat-card {
            background: white;
            padding: 1.5rem;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
            text-align: center;
            border-bottom: 4px solid var(--primary);
        }

        .stat-card h3 {
            margin: 0;
            color: #666;
            font-size: 0.9rem;
        }

        .stat-card .value {
            font-size: 2rem;
            font-weight: 700;
            color: var(--primary);
            margin: 0.5rem 0;
        }

        .card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
            margin-bottom: 2rem;
            overflow: hidden;
        }

        .card-header {
            padding: 1.2rem;
            border-bottom: 1px solid #eee;
            background: #fafafa;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .card-header h2 {
            margin: 0;
            font-size: 1.1rem;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            padding: 1rem;
            text-align: right;
            border-bottom: 1px solid #eee;
        }

        th {
            background: #f8f9fa;
            font-weight: 700;
            color: #555;
        }

        .badge {
            padding: 0.25rem 0.6rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 700;
        }

        .badge-active {
            background: #e3f9f1;
            color: #1a7f5a;
        }

        .badge-expired {
            background: #fbe9e9;
            color: #c53030;
        }

        .btn {
            padding: 0.6rem 1.2rem;
            border-radius: 8px;
            border: none;
            cursor: pointer;
            font-family: inherit;
            font-weight: 700;
            transition: 0.3s;
            text-decoration: none;
            display: inline-block;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: #304fd0;
            transform: translateY(-2px);
        }

        .key-copy {
            background: #f1f3f5;
            padding: 0.4rem 0.6rem;
            border-radius: 6px;
            font-family: monospace;
            cursor: pointer;
            border: 1px dashed #ccc;
        }

        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: white;
            padding: 2rem;
            border-radius: 15px;
            width: 400px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
        }

        .form-group {
            margin-bottom: 1rem;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
        }

        .form-group input,
        .form-group select {
            width: 100%;
            padding: 0.8rem;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-family: inherit;
        }

        /* Smart Suggestions */
        .suggestions {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 1.5rem;
            border-radius: 12px;
            margin-bottom: 2rem;
        }

        .suggestions h3 {
            margin-top: 0;
            font-size: 1.2rem;
        }

        .suggestion-item {
            background: rgba(255, 255, 255, 0.1);
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .site-info {
            font-size: 0.85rem;
            color: #666;
        }

        .site-url {
            color: var(--primary);
            text-decoration: none;
        }
    </style>
</head>

<body>

    <div class="navbar">
        <div class="logo" style="font-size: 1.4rem; font-weight: 700;">Author Box Pro Dashboard 🚀</div>
        <div style="background: rgba(255,255,255,0.1); padding: 5px 15px; border-radius: 20px;">مدير النظام</div>
    </div>

    <div class="container">

        <!-- Smart Suggestions -->
        <div class="suggestions">
            <h3>💡 مقترحات ذكية للمدير</h3>
            <div class="suggestion-item">
                <span>⚡</span>
                <span><b>نصيحة أداء:</b> هناك <?php echo $total_licenses - $active_activations; ?> من التراخيص المباعة
                    لم يتم تفعيلها بعد. ربما مفيد إرسال رسالة تذكريّة للعملاء.</span>
            </div>
            <div class="suggestion-item">
                <span>🛡️</span>
                <span><b>أمان من الفئة S:</b> نظام التحقق يعمل الآن بـ Domain Lock. لا يمكن للمفتاح الواحد العمل في أكثر
                    من موقع، مما يحمي أرباحك.</span>
            </div>
        </div>

        <div class="stats-grid">
            <div class="stat-card">
                <h3>إجمالي التراخيص</h3>
                <div class="value"><?php echo $total_licenses; ?></div>
            </div>
            <div class="stat-card" style="border-bottom-color: var(--success);">
                <h3>المواقع المفعلة حالياً</h3>
                <div class="value"><?php echo $active_activations; ?></div>
            </div>
            <div class="stat-card" style="border-bottom-color: var(--warning);">
                <h3>خطة Annual</h3>
                <div class="value"><?php
                $annual_count = 0;
                foreach ($all_licenses as $l)
                    if ($l['plan'] == 'annual')
                        $annual_count++;
                echo $annual_count;
                ?></div>
            </div>
            <div class="stat-card" style="border-bottom-color: var(--dark);">
                <h3>إصدار البلجن</h3>
                <div class="value">1.1.0</div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h2>إدارة التراخيص والمواقع</h2>
                <button class="btn btn-primary" onclick="document.getElementById('addModal').style.display='flex'">إضافة
                    ترخيص جديد +</button>
            </div>
            <table>
                <thead>
                    <tr>
                        <th>المفتاح</th>
                        <th>البريد الإلكتروني</th>
                        <th>تاريخ البداية</th>
                        <th>الموقع المفعّل</th>
                        <th>الحالة</th>
                        <th>تاريخ الانتهاء</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($all_licenses as $license): ?>
                        <tr>
                            <td>
                                <span class="key-copy" onclick="copyToClipboard('<?php echo $license['license_key']; ?>')"
                                    title="اضغط للنسخ">
                                    <?php echo $license['license_key']; ?>
                                </span>
                            </td>
                            <td><?php echo $license['email']; ?></td>
                            <td style="font-size: 0.9rem; color: #777;">
                                <?php echo date('Y-m-d', strtotime($license['created_at'])); ?>
                            </td>
                            <td>
                                <?php if ($license['active_url']): ?>
                                    <div class="site-info">
                                        <b><?php echo $license['site_name'] ?: 'بدون اسم'; ?></b><br>
                                        <a href="http://<?php echo $license['active_url']; ?>" target="_blank"
                                            class="site-url"><?php echo $license['active_url']; ?></a>
                                    </div>
                                <?php else: ?>
                                    <span style="color: #ccc; font-style: italic;">غير مفعل بعد</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="badge badge-<?php echo $license['status']; ?>">
                                    <?php echo $license['status'] == 'active' ? 'نظامي' : 'متوقف'; ?>
                                </span>
                            </td>
                            <td>
                                <?php echo $license['expires_at'] ? date('Y-m-d', strtotime($license['expires_at'])) : 'دائم (LifeTime)'; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="card">
            <div class="card-header">
                <h2>آخر العمليات الأمنية</h2>
            </div>
            <table>
                <thead>
                    <tr>
                        <th>الحدث</th>
                        <th>التفاصيل</th>
                        <th>عنوان IP</th>
                        <th>التوقيت</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recent_logs as $log): ?>
                        <tr>
                            <td><b><?php echo strtoupper($log['action']); ?></b></td>
                            <td><?php echo $log['details']; ?></td>
                            <td><code><?php echo $log['ip_address']; ?></code></td>
                            <td><?php echo date('H:i - Y/m/d', strtotime($log['created_at'])); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal Form -->
    <div id="addModal" class="modal">
        <div class="modal-content">
            <h2 style="margin-top: 0;">إنشاء ترخيص جديد</h2>
            <form method="POST">
                <input type="hidden" name="action" value="add_license">
                <div class="form-group">
                    <label>البريد الإلكتروني للعميل</label>
                    <input type="email" name="email" required placeholder="example@mail.com">
                </div>
                <div class="form-group">
                    <label>الخطة</label>
                    <select name="plan">
                        <option value="annual">سنوية (Annual)</option>
                        <option value="lifetime">مدى الحياة (Lifetime)</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>تاريخ الانتهاء (اختياري)</label>
                    <input type="date" name="expires_at">
                </div>
                <div style="display: flex; gap: 10px; margin-top: 1.5rem;">
                    <button type="submit" class="btn btn-primary" style="flex: 1;">حفظ الترخيص</button>
                    <button type="button" class="btn" style="background: #eee; flex: 1;"
                        onclick="document.getElementById('addModal').style.display='none'">إلغاء</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text);
            alert('تم نسخ المفتاح: ' + text);
        }

        // إغلاق المنبثق عند الضغط خارجه
        window.onclick = function (event) {
            let modal = document.getElementById('addModal');
            if (event.target == modal) modal.style.display = "none";
        }
    </script>

</body>

</html>