-- جدول التراخيص
-- License Server Database Schema

CREATE TABLE IF NOT EXISTS `licenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `license_key` varchar(50) NOT NULL,
  `email` varchar(255) NOT NULL,
  `site_url` varchar(255) DEFAULT NULL,
  `product` varchar(100) NOT NULL DEFAULT 'author-box-pro',
  `plan` varchar(50) NOT NULL,
  `status` enum('active','expired','cancelled','suspended') NOT NULL DEFAULT 'active',
  `max_sites` int(11) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` datetime DEFAULT NULL,
  `activated_at` datetime DEFAULT NULL,
  `last_check` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `license_key` (`license_key`),
  KEY `email` (`email`),
  KEY `site_url` (`site_url`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- جدول المواقع المفعّلة
CREATE TABLE IF NOT EXISTS `activations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `license_id` int(11) NOT NULL,
  `site_url` varchar(255) NOT NULL,
  `site_name` varchar(255) DEFAULT NULL,
  `activated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_check` datetime DEFAULT NULL,
  `version` varchar(20) DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `license_id` (`license_id`),
  KEY `site_url` (`site_url`),
  CONSTRAINT `fk_license` FOREIGN KEY (`license_id`) REFERENCES `licenses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- جدول سجل الأحداث
CREATE TABLE IF NOT EXISTS `license_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `license_id` int(11) NOT NULL,
  `action` varchar(50) NOT NULL,
  `details` text,
  `ip_address` varchar(45) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `license_id` (`license_id`),
  KEY `action` (`action`),
  CONSTRAINT `fk_log_license` FOREIGN KEY (`license_id`) REFERENCES `licenses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إدراج ترخيص تجريبي للاختبار
INSERT INTO `licenses` (`license_key`, `email`, `plan`, `status`, `max_sites`, `expires_at`) 
VALUES 
('TEST-1234-5678-ABCD', 'test@example.com', 'annual', 'active', 1, DATE_ADD(NOW(), INTERVAL 1 YEAR));
